/*
 * This class is the container for classroom
 * This class passes and converts all scheduling
 * requests and replies between Schedule and GUIMain
 */

package creeksidescheduler;
public class Classroom {

    private String Name="Please Enter";
    private String Grade="K";
    private Schedule Sched=new Schedule();


    public void Classroom(){
    }

    //create the schedule
    public void createClass(){
        Sched.createSched();
    }

    //set classroom name
    public void setName(String name){
        Name = name;
        Sched.setOwner(Name);
    }

    //get classroom name
    public String getName(){
        return Name;
    }

    //set grade
    public void setGrade(String grade){
        Grade=grade;
    }

    //get grade
    public String getGrade(){
        return Grade;
    }

    //get the whole schedule
    public int[][] getSched(){
        return Sched.getSchedule();
    }

    //get the schedule time info: Hour, Minute, Block Times
    public int[] getTimeInfo(){
        return Sched.getTimeInfo();
    }

    //get a specific Schedule slot info
    public int getSchedSlot(int d, int slot){
        return Sched.getTimeSlot(d, slot);
    }

    //remove a Special from the class Schedule
    public boolean remSpecial(Special Spec){
        return Sched.remSpecialFromSchedule(Spec);
    }

    //add a special into the schedule
    public boolean addSpecialToSchedule(Special spec){
        boolean Added=false;

        for (int x=0;x<Sched.getMaxDays();x++){
            //add a daily special
            if (spec.isDaily()){
                Added=Sched.addToSchedule(spec.getID(), x, convertTime(spec.getStartTime()), convertTime(spec.getEndTime()));
            }
            //add a special to a specific day
            else{
                if (x==spec.getDOW()){
                    Added=Sched.addToSchedule(spec.getID(), x, convertTime(spec.getStartTime()), convertTime(spec.getEndTime()));
                }
            }
        }

        return Added;
    }

    //check for a conflict from a special
    public boolean noConflict(Special spec){
        boolean no_Conflict=true;

        for (int x=0;x<Sched.getMaxDays()&&no_Conflict;x++){
            if(spec.isDaily()){
                no_Conflict=Sched.checkIfOpen(x, convertTime(spec.getStartTime()), convertTime(spec.getEndTime()),spec.getID());
            }
            else{
                if (x==spec.getDOW()){
                    no_Conflict=Sched.checkIfOpen(x, convertTime(spec.getStartTime()), convertTime(spec.getEndTime()),spec.getID());
                }
            }
        }

        return no_Conflict;

    }

    //convert time from String to an int and then convert to the schedule slot
    private int convertTime(String S_Time){
        int Sched_Slot;
        int hour,t_hour;
        int min,t_min;
        int [] TIME;

        //convert time to an int
        //time will be in HH:MM format
        hour=Integer.parseInt(S_Time.substring(0, 2));//pull out hour
        min=Integer.parseInt(S_Time.substring(3, 5));//pull out minute

        //convert to schedule format
        TIME=Sched.getTimeInfo();//Hour, Minute, Timeblock
        //calculate hours
        if (hour<TIME[0]){
            t_hour=hour-TIME[0]+12;
        }
        else{
            t_hour=hour-TIME[0];
        }
        //calculate minutes. Negative minutes are acceptable
        t_min=min-TIME[1];
        //calculate time slot
        Sched_Slot=(t_hour*60+t_min)/TIME[2];

        return Sched_Slot;
    }
}
